jQuery(document).ready(function($) {
    // Handle form submission for saving settings
    $('#api-tabs-settings').on('submit', function(e) {
        e.preventDefault();

        var token = $('#token').val();
        var url = $('#url').val();
        var division = $('#division').val();
        var section = $('#section').val();
        var $submitBtn = $(this).find('button[type="submit"]');
        var $message = $('#save-message');

        // Disable submit button
        $submitBtn.prop('disabled', true).text('Saving...');

        $.ajax({
            url: broadercasterFuneralServiceAdmin.ajax_url,
            type: 'POST',
            data: {
                action: 'save_data',
                token: token,
                url: url,
                division: division,
                section: section,
                nonce: broadercasterFuneralServiceAdmin.nonce
            },
            success: function(response) {
                if (response.success) {
                    $message
                        .removeClass('notice-error')
                        .addClass('notice notice-success')
                        .html('<p>' + response.data + '</p>')
                        .show();
                } else {
                    $message
                        .removeClass('notice-success')
                        .addClass('notice notice-error')
                        .html('<p>Error: ' + response.data + '</p>')
                        .show();
                }
            },
            error: function(xhr, status, error) {
                $message
                    .removeClass('notice-success')
                    .addClass('notice notice-error')
                    .html('<p>Error: ' + error + '</p>')
                    .show();
            },
            complete: function() {
                // Re-enable submit button
                $submitBtn.prop('disabled', false).text('Save Settings');

                // Hide message after 3 seconds
                setTimeout(function() {
                    $message.fadeOut();
                }, 3000);
            }
        });
    });
});
