# Broadercaster Funeral Services Plugin

A unified WordPress plugin that provides complete funeral services functionality through two powerful shortcodes.

## Features

- **Services List**: Display live, upcoming, and completed funeral services
- **Individual Service View**: Show detailed information for specific services
- **Auto-Height Adjustment**: Iframes automatically resize to fit content
- **Customizable Styling**: Control height, borders, and border radius
- **Responsive Design**: Works seamlessly on all devices
- **Easy Configuration**: Simple admin panel for API settings

## Installation

1. Copy the `broadercaster-funeral-plugin` directory to `wp-content/plugins/`
2. Activate the plugin through the WordPress admin panel (Plugins → Activate)
3. Configure your API settings in Settings → BroaderCaster

## Configuration

Navigate to **Settings → BroaderCaster** in your WordPress admin panel:

- **Server URL**: Enter your Broadercaster API URL (e.g., `https://funeralservices.broadercaster.app/api`)
- **Token**: Enter your authentication token

## Usage

### Services List Shortcode

Display the funeral services list with live, upcoming, and completed services:

```
[broadercaster_funeral_services]
```

**Customization Options:**

```
[broadercaster_funeral_services min_height="600px" border="1px solid #ccc" border_radius="12px"]
```

**Available Attributes:**
- `min_height` - Minimum iframe height (default: `400px`)
- `border` - CSS border style (default: `none`)
- `border_radius` - CSS border radius (default: `8px`)

### Service View Shortcode

Display an individual service detail page:

```
[broadercaster_service_view]
```

**Important:** This shortcode requires a `uuid` URL parameter. For example:
```
https://yoursite.com/service-details/?uuid=abc123def456
```

**Customization Options:**

```
[broadercaster_service_view min_height="800px" border="1px solid #ddd" border_radius="8px"]
```

**Available Attributes:**
- `min_height` - Minimum iframe height (default: `400px`)
- `border` - CSS border style (default: `none`)
- `border_radius` - CSS border radius (default: `8px`)
- `base_url` - Custom base URL for the service view (default: `https://broadercaster.app/eventsfrontend/service_view.php`)

**Using a Custom Base URL:**

```
[broadercaster_service_view base_url="https://staging.broadercaster.app/eventsfrontend/service_view.php"]
```

## Technical Details

### File Structure

```
broadercaster-funeral-plugin/
├── plugin.php                    # Main plugin file
├── README.md                     # This file
└── assets/
    ├── admin.js                  # Admin panel functionality
    └── iframe-handler.js         # Shared iframe utilities
```

### How It Works

Both shortcodes render iframes that:
1. Display a loading spinner while content loads
2. Listen for `postMessage` events from the iframe
3. Automatically adjust height when content changes
4. Poll for height updates every 500ms as a fallback
5. Handle loading errors gracefully

### Backward Compatibility

This plugin combines and replaces:
- **Broadercaster Funeral Service Plugin** (v1.3)
- **Broadercaster Service View Plugin** (v1.0)

The services list shortcode is named `[broadercaster_funeral_services]` (note: plural "services") to avoid conflicts if you're migrating from the old plugin.

## Migration Guide

If you're upgrading from the separate plugins:

1. **Deactivate and delete the old plugins:**
   - Broadercaster Funeral Service Plugin
   - Broadercaster Service View Plugin

2. **Install and activate this unified plugin**

3. **Update your shortcodes:**
   - Old: `[broadercaster_funeral_service_tab]` → New: `[broadercaster_funeral_services]`
   - `[broadercaster_service_view]` remains the same

4. **Reconfigure settings:**
   - Your API URL and token will need to be re-entered in Settings → BroaderCaster

## Support

For issues or questions, please contact your Broadercaster administrator.

## Version History

- **v2.0** - Initial unified plugin release combining both services list and service view functionality
- Replaces v1.3 of Funeral Service Plugin and v1.0 of Service View Plugin

## Author

Dan Liu

## License

Proprietary - Broadercaster
